unit main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.StdCtrls, Vcl.Buttons, Vcl.ExtCtrls;

type
  TCreateChatForm = function(AMainHandle: HWND; AId, APwd, APName: PChar;
    AIsAutoLogin: Boolean): HWND; cdecl;
  TSendMessage = function(AId, AMsg: PChar; ASendMethod: Integer): Boolean; cdecl;
  TDestoryChatForm = procedure; cdecl;
//  TMessageType = (mstChat, mstForm);

  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    meMsg: TMemo;
    edId: TLabeledEdit;
    rgMsgType: TRadioGroup;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);

  private
    FChatFormHwnd: HWND;
    FChatFormLib: THandle;

  public
    Procedure WMCopyData(var AMsg: TWMCopyData); message WM_COPYDATA;

  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  ShowWindow(FChatFormHwnd, SW_SHOW);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var
  SendMessage: TSendMessage;
begin
  if FChatFormLib <> 0 then
  begin
    @SendMessage := GetProcAddress(FChatFormLib, 'SendMessage');
    if @SendMessage <> nil then
    begin
      if SendMessage(PChar(edId.Text), PChar(meMsg.Lines.Text),
         rgMsgType.ItemIndex) then
        ShowMessage('OK')
      else
        ShowMessage('False')
    end;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  DestoryChatForm: TDestoryChatForm;
begin
  if FChatFormLib <> 0 then
  begin
    @DestoryChatForm := GetProcAddress(FChatFormLib, 'DestoryChatForm');
    if @DestoryChatForm <> nil then
      DestoryChatForm;
    FreeLibrary(FChatFormLib);
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  CreateChatForm: TCreateChatForm;
begin
  FChatFormLib := Loadlibrary('UDSClientLib.dll');
  if FChatFormLib <> 0 then
  begin
    @CreateChatForm := GetProcAddress(FChatFormLib, 'CreateChatForm');
    if @CreateChatForm <> nil then
      FChatFormHwnd := CreateChatForm(Self.Handle, PChar('aa'), PChar('aa'),
        PChar('TestUser'), True);
  end;
end;

procedure TForm1.WMCopyData(var AMsg: TWMCopyData);
  procedure DisplayMsg(AStr: String);
  var
    i: Integer;
    cId, cNm, cMsg: String;
  begin
    i := Pos(#2, AStr);
    if i <= 0 then
      Exit;
    cId := Copy(AStr, 1, i -1);
    cMsg := Copy(AStr, i + 1, Length(AStr));

    i := Pos(#1, AStr);
    if i <= 0 then
      Exit;

    cNm := Copy(cId, 1, i -1);
    cId := Copy(cId, i + 1, Length(cId));

    ShowMessage('ID = ' + cId + #$D#$A +
      'Name = ' + cNm + #$D#$A +
      'Message = ' + cMsg);
  end;
var
  PBuff: PChar;
  SubStr: string;
begin
  PBuff := StrALloc(AMsg.CopyDataStruct.cbData);
  try
    StrCopy(PBuff, AMsg.CopyDataStruct.lpData);
    SubStr := Trim(PBuff);
    if AMsg.CopyDataStruct.dwData = $0717 then
      DisplayMsg(SubStr);
  finally
    StrDispose(PBuff);
  end;

  inherited;
end;

end.
